package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LotteryUsersAdapter;
import app.firezone.synk.network.Adapter.RulesAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityLotteryInfoBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.CheckJoinedResponse;
import app.firezone.synk.network.model.JoinedMatchResponse;
import app.firezone.synk.network.model.LotteryJoinedModel;
import app.firezone.synk.network.model.LotteryJoinedResponse;
import app.firezone.synk.network.model.MatchRulesResponse;
import app.firezone.synk.network.model.RulesModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class LotteryInfoActivity extends AppCompatActivity {


    ActivityLotteryInfoBinding binding;


    LotteryUsersAdapter mAdapter;

    ArrayList<LotteryJoinedModel> mlist;

    ArrayList<RulesModel> rulesModels;


    RulesAdapter adapter;

    ProgressDialog progressDialog;

    Dialog dialog;

    String lotteryId, Prize, entryFees, totalPlayers;


    String  email, name, phone;

    long winBalance, depoBalance, bonusBalance, totalCoin, entryFee, matchPlayed, totalPlayer, player;

    FirebaseDatabase database;

    private MyApi myApi;

    long userId;

     FirebaseUser auth;

    DatabaseReference dr;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityLotteryInfoBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        binding.backArrow.setOnClickListener(v -> finish());

        userId = SharedPrefManager.getInstance(LotteryInfoActivity.this).getUserId();
       // loadData();

       // checkJoinedUsers();

        progressDialog = new ProgressDialog(LotteryInfoActivity.this);
        progressDialog.setTitle("Registering Lottery");
        progressDialog.setMessage("Please Wait.....");
        progressDialog.setCancelable(false);


        auth = FirebaseAuth.getInstance().getCurrentUser();

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        database = FirebaseDatabase.getInstance();

        lotteryId = getIntent().getStringExtra("lotteryId");
        entryFees = getIntent().getStringExtra("entryFee");
        totalPlayers = getIntent().getStringExtra("totalSeat");
        Prize = getIntent().getStringExtra("Prize");

        if (entryFees == null) entryFees = "0";
        if (totalPlayers == null) totalPlayers = "0";
        if (Prize == null) Prize = "0";

        entryFee = Long.parseLong(entryFees);
        totalPlayer = Long.parseLong(totalPlayers);


        binding.perkill.setText("₹" +entryFees);
        binding.prizepool.setText("₹" + Prize);



        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();

                    winBalance = model.getWinBalance();
                    depoBalance = model.getDepoBalance();
                    bonusBalance = model.getBonusBalance();

                    totalCoin = model.getDepoBalance() + model.getWinBalance();


                    email = model.getEmail();
                    name = model.getName();
                    phone = model.getPhoneno();
                } else {
                    Toast.makeText(LotteryInfoActivity.this, "Failed to fetch user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });

        binding.joinedRecy.setLayoutManager(new LinearLayoutManager(this));
        mlist = new ArrayList<LotteryJoinedModel>();

        Call<LotteryJoinedResponse> joinedCall = myApi.fetchLotteryJoined(Long.parseLong(lotteryId));
        joinedCall.enqueue(new Callback<LotteryJoinedResponse>() {
            @Override
            public void onResponse(Call<LotteryJoinedResponse> call, Response<LotteryJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                    mlist.clear();

                    ArrayList<LotteryJoinedModel> joinedUsers = response.body().getData();
                    if (joinedUsers != null && !joinedUsers.isEmpty()) {
                        for (LotteryJoinedModel user : joinedUsers) {
                            mlist.add(user);
                        }
                        mAdapter = new LotteryUsersAdapter(mlist, LotteryInfoActivity.this);
                        binding.joinedRecy.setAdapter(mAdapter);
                    } else {
                        Toast.makeText(LotteryInfoActivity.this, "No joined users found", Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(LotteryInfoActivity.this, "Failed to fetch data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<LotteryJoinedResponse> call, Throwable t) {
                Toast.makeText(LotteryInfoActivity.this, "Error fetching joined users: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });





        binding.rulesRecy.setLayoutManager(new LinearLayoutManager(this));
        rulesModels = new ArrayList<>();


        Call<MatchRulesResponse> ruless = myApi.fetchMatchRules("Lottery");

        ruless.enqueue(new Callback<MatchRulesResponse>() {
            @Override
            public void onResponse(Call<MatchRulesResponse> call, Response<MatchRulesResponse> response) {
                if (response.isSuccessful() && response.body() != null && response.body().isSuccess()) {
                    rulesModels.clear();
                    rulesModels.addAll(response.body().getMatchRules());
                    adapter = new RulesAdapter(rulesModels, LotteryInfoActivity.this);
                    binding.rulesRecy.setAdapter(adapter);
                } else {
                    Toast.makeText(LotteryInfoActivity.this, "No Rules Found: " + (response.body() != null ? response.body().getMessage() : "Unknown Error"), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<MatchRulesResponse> call, Throwable t) {
                Toast.makeText(LotteryInfoActivity.this, "Failed to load rules: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });


        binding.subssribeBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                deductCoin();
            }
        });




        // Check if the user has joined the lottery using checkIfUserJoined API
        HashMap<String, Object> body = new HashMap<>();
        body.put("userId", userId);
        body.put("lotteryid", lotteryId);

        Call<CheckJoinedResponse> calls = myApi.checkIfUserJoined(body);
        calls.enqueue(new Callback<CheckJoinedResponse>() {
            @Override
            public void onResponse(Call<CheckJoinedResponse> call, Response<CheckJoinedResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()){

                        binding.joinText.setText("Registered");
                        binding.subssribeBtn.setClickable(false);

                        binding.subssribeBtn.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                Toast.makeText(LotteryInfoActivity.this, "Already Registered", Toast.LENGTH_SHORT).show();
                            }
                        });

                    }
                    else {
                        binding.joinText.setText("Register Now");

                    }
                }
            }

            @Override
            public void onFailure(Call<CheckJoinedResponse> call, Throwable t) {
                Toast.makeText(LotteryInfoActivity.this, "Error checking lottery status: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


    private void deductCoin(){

        if (entryFee == 0){
            saveLotteryJoinData();
        }else {

            if (entryFee<= depoBalance){


                long depoBal = depoBalance - entryFee;

                HashMap<String, Object> coinMap = new HashMap<>();
                coinMap.put("depoBalance",depoBal);


                Call<UserResponse> updateCall = myApi.updateUser(userId, coinMap);

                updateCall.enqueue(new Callback<UserResponse>() {
                    @Override
                    public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                        if (response.isSuccessful() && response.body() != null) {
                            saveLotteryJoinData();
                            saveUsersTransactionDetails();
                            Toast.makeText(LotteryInfoActivity.this, "Coin Debited...", Toast.LENGTH_SHORT).show();
                        } else {
                            Log.e("DeductCoinError", "Failed to deduct coins. Response: " + response.message());
                            Toast.makeText(LotteryInfoActivity.this, "Failed to deduct coins. Please try again.", Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onFailure(Call<UserResponse> call, Throwable t) {
                        Log.e("DeductCoinError", "API call failed: " + t.getMessage());
                        Toast.makeText(LotteryInfoActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                });



            } else if (entryFee<= totalCoin) {


                long requiredCoin =  entryFee - depoBalance;

                long winCoin =  winBalance - requiredCoin;
                long totaldepo = depoBalance - depoBalance;


                HashMap<String, Object> coinMap = new HashMap<>();
                coinMap.put("depoBalance", totaldepo);
                coinMap.put("winBalance",winCoin);


                Call<UserResponse> updateCall = myApi.updateUser(userId, coinMap);

                updateCall.enqueue(new Callback<UserResponse>() {
                    @Override
                    public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                        if (response.isSuccessful() && response.body() != null) {
                            saveLotteryJoinData();
                            saveUsersTransactionDetails();
                            Toast.makeText(LotteryInfoActivity.this, "Coin Debited...", Toast.LENGTH_SHORT).show();
                        } else {
                            Log.e("DeductCoinError", "Failed to deduct coins. Response: " + response.message());
                            Toast.makeText(LotteryInfoActivity.this, "Failed to deduct coins. Please try again.", Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onFailure(Call<UserResponse> call, Throwable t) {
                        Log.e("DeductCoinError", "API call failed: " + t.getMessage());
                        Toast.makeText(LotteryInfoActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                    }
                });



            }else {
                showNoBalanceDailog();
                progressDialog.dismiss();
                Toast.makeText(this, "Not Enough Money", Toast.LENGTH_SHORT).show();
            }

        }

    }


    private void saveLotteryJoinData() {
        if (phone == null || email == null || name == null || lotteryId == null || entryFees == null || Prize == null) {
            Toast.makeText(this, "Missing data. Please check your details.", Toast.LENGTH_SHORT).show();
            return;
        }



        Calendar calForDate = Calendar.getInstance();
        SimpleDateFormat currentDate = new SimpleDateFormat("dd-MM-yy", Locale.getDefault());
        String date = currentDate.format(calForDate.getTime());

        String currentTime = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(new Date());
        String totalPay = String.valueOf(entryFee);
        progressDialog.show();

        myApi.storeLotteryUser(
                Long.parseLong(lotteryId),
                email,
                name,
                phone,
                String.valueOf(userId),
                date,
                currentTime,
                totalPay,
                "0",
                "Expert"
        ).enqueue(new Callback<JoinedMatchResponse>() {
            @Override
            public void onResponse(Call<JoinedMatchResponse> call, Response<JoinedMatchResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    progressDialog.dismiss();
                    binding.joinText.setText("Registered");
                    binding.subssribeBtn.setBackgroundColor(R.drawable.btn_false);
                    binding.subssribeBtn.setClickable(false);
                    Toast.makeText(LotteryInfoActivity.this, "Joined Successfully...", Toast.LENGTH_SHORT).show();
                } else {
                    try {
                        String errorMessage = response.errorBody().string();
                        Toast.makeText(LotteryInfoActivity.this, "Failed to join: " + errorMessage, Toast.LENGTH_LONG).show();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onFailure(Call<JoinedMatchResponse> call, Throwable t) {
                Toast.makeText(LotteryInfoActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }



    private void saveUsersTransactionDetails() {
        // Get user details
        long userIdLong = SharedPrefManager.getInstance(LotteryInfoActivity.this).getUserId();
        String userId = String.valueOf(userIdLong); // Convert to String for API call
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(entryFee);

        // Initialize API Client


        Call<TransactionModel> call = myApi.storeUserTransaction(
                userId,
                "Withdraw", // type
                email,
                inputCoin, // amount
                date,
                time,
                transactionId,
                "Wallet", // method
                "Pending" // status
        );

        call.enqueue(new Callback<TransactionModel>() {
            @Override
            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(LotteryInfoActivity.this, "Transaction Recorded Successfully", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(LotteryInfoActivity.this, "Failed to Record Transaction: " + response.message(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText(LotteryInfoActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void showNoBalanceDailog() {
        ConstraintLayout constraintLayout =  findViewById(R.id.resetConstraint);
        View view = LayoutInflater.from(LotteryInfoActivity.this).inflate(R.layout.wrong_dailog, constraintLayout);
        Button doneBtn =  view.findViewById(R.id.btnDone);


        AlertDialog.Builder builder= new AlertDialog.Builder(LotteryInfoActivity.this);
        builder.setView(view);
        final AlertDialog alertDialog =  builder.create();


        doneBtn.findViewById(R.id.btnDone).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });

        if (alertDialog.getWindow() != null){
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable());
        }

        alertDialog.show();

    }

}